<?php
$secretKey = "montazerOutu3342";

if ($_GET['secret'] !== $secretKey) {
  echo json_encode(["status" => "error", "message" => "Unauthorized"]);
  exit;
}

$config = require_once __DIR__ . '/system/config_database.php';
$db = $config['db'];

try {
  $conn = new PDO("mysql:host={$db['host']};dbname={$db['name']};charset={$db['charset']}", $db['user'], $db['pass']);
  $conn->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
} catch (PDOException $e) {
  echo json_encode(["status" => "error", "message" => "Database connection failed"]);
  exit;
}

$username = $_GET['username'] ?? null;
$amount   = floatval($_GET['amount'] ?? 0);
$note     = $_GET['note'] ?? 'Manual API Add';

if (!$username || $amount <= 0) {
  echo json_encode(["status" => "error", "message" => "Invalid data"]);
  exit;
}

$stmt = $conn->prepare("SELECT * FROM clients WHERE username = :username LIMIT 1");
$stmt->execute(["username" => $username]);
$user = $stmt->fetch(PDO::FETCH_ASSOC);

if (!$user) {
  echo json_encode(["status" => "error", "message" => "User not found"]);
  exit;
}

$conn->beginTransaction();

$insert = $conn->prepare("
  INSERT INTO payments 
  SET payment_status=3, payment_mode='Manual', payment_amount=:amount,
      payment_method=99, payment_delivery=2, payment_note=:note, 
      payment_update_date=:date, payment_create_date=:date2, 
      client_id=:client_id, client_balance=:balance
");
$successInsert = $insert->execute([
  "amount"     => $amount,
  "note"       => $note,
  "date"       => date("Y-m-d H:i:s"),
  "date2"      => date("Y-m-d H:i:s"),
  "client_id"  => $user["client_id"],
  "balance"    => $user["balance"]
]);

$successUpdate = $conn->prepare("UPDATE clients SET balance = balance + :amount WHERE client_id = :id")
                      ->execute(["amount" => $amount, "id" => $user["client_id"]]);

if ($successInsert && $successUpdate) {
  $conn->commit();
  echo json_encode(["status" => "success", "message" => "Balance updated successfully"]);
} else {
  $conn->rollBack();
  echo json_encode(["status" => "error", "message" => "Failed to update balance"]);
}
